import QtQuick 2.12
import QtQuick.Window 2.12
import "MedComponents"

Window {
    visible: true
    width: 640
    height: 480
    title: qsTr("Medish Demo")

    Rectangle {
        id: headerBar
        anchors {
            top: parent.top
            left: parent.left; right: parent.right
        }
        height: parent.height * 0.08
        DateTimeLabel { anchors.fill: parent }
    }

    Rectangle {
        id: mainContent
        anchors{ top: headerBar.bottom; bottom: parent.bottom; left: parent.left; right: parent.right }
        color: "cyan"
        Button {
            anchors.centerIn: parent
            onClicked: virtK.visible = !virtK.visible
            height: parent.height * 0.2
            radius: 12
        }
        VirtualKeyboard {
            id:virtK
            anchors.bottom: parent.bottom
            visible: false
            onKeyPressed: console.log(key)
            onBackspacePressed: console.log("BACKSPACE")
            onHidePressed: virtK.visible = false
        }
    }

}
